package zahlen;

import java.util.ArrayList;
import java.util.List;

public class Zahlen
{
    public static final String[]    tausendernamen = new String[]
    {
        "",
        "tausend",
        "millionen",
        "milliarden",
        "billionen",
        "billiarden",
        "trillionen",
        "trilliarden",
        "quadrillionen",
        "quadrilliarde",
    };
    
    public static String[]  zahlennamen = new String[]
    {
        "null",
        "ein",
        "zwei",
        "drei",
        "vier",
        "fünf",
        "sechs",
        "sieben",
        "acht",
        "neun",
        "zehn"
    };
    
    public static void main(String[] args)
    {
        long eingabe = 1L;
        
        System.out.printf("Eingabe: %,d\n", eingabe);
        
        List<Integer> tausenderBlöcke = inTausenderZerlegen(eingabe);
        reihenfolgeInvertieren(tausenderBlöcke);
        
        for(int i = 0; i < tausenderBlöcke.size(); ++i)
        {
            int exponent = tausenderBlöcke.size() - 1 - i;
            
            int tausender = tausenderBlöcke.get(i);
            
            if(tausender > 0)
            {
                System.out.print(blocknameFür(tausender) + tausendernamen[exponent]);
            }
        }
        
        System.out.println("");
    }
    
    public static String blocknameFür(int zahl)
    {
        StringBuilder wort = new StringBuilder();
        if(zahl < 1000 && zahl > 0)
        {
            int hunderter = zahl / 100;
            int zehner = (zahl / 10) % 10;
            int einer = zahl % 10;
            
            if(hunderter > 0)
            {
                wort.append(zahlennamen[hunderter]);
                wort.append("hundert");
            }
            
            if(zehner != 1 && zehner > 0)
            {
                wort.append(zahlennamen[einer]);
                wort.append("und");
            }
            
            switch(zehner)
            {
                case 0:
                {
                    if(einer > 0)
                    {
                        wort.append(zahlennamen[einer]);
                    }
                    break;
                }
                case 1:
                {
                    switch(einer)
                    {
                        case 0: break;
                        case 1: wort.append("elf"); break;
                        case 2: wort.append("zwölf"); break;
                        default:
                        {
                            wort.append(zahlennamen[einer]);
                            wort.append("zehn");
                            break;
                        }
                    }
                    break;
                }
                case 2: wort.append("zwanzig"); break;
                case 3: wort.append("dreißig"); break;
                default:
                {
                    wort.append(zahlennamen[zehner]);
                    wort.append("zig");
                    break;
                }
            }

            return wort.toString();
        }
        
        return "Bullshit";
    }
    
    public static void reihenfolgeInvertieren(List<Integer> blöcke)
    {
        for(int i = 0; i < blöcke.size() / 2; ++i)
        {
            Integer temp = blöcke.get(i);
            blöcke.set(i, blöcke.get(blöcke.size() - i - 1));
            blöcke.set(blöcke.size() - i - 1, temp);
        }
    }
    
    public static List<Integer> inTausenderZerlegen(long zahl)
    {
        List<Integer> blöcke = new ArrayList<Integer>();
        
        int block;
        while(zahl > 0)
        {
            block = (int)(zahl % 1000L);
            zahl /= 1000L;
            
            blöcke.add(block);
        }
        
        return blöcke;
    }
}
